//
//  SendMailKit.h
//  SendMailKit
//
//  Created by Stefan on 20.02.13.
//  Copyright (c) 2013 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SendMailKitMessage.h"

@interface SendMailKit : NSObject
{
}

@property (strong,nonatomic) NSMutableSet * userScriptsPaths;
@property (strong,nonatomic) NSArray * sharingServices;
@property (assign) BOOL includeSharingServices;


+(SendMailKit *)sharedKit;
+(void)editScript;
+(NSString *)defaultScriptPath;
+(NSString *)defaultMailClient;
+(NSString *)defaultMailClientName;
+(NSSharingService *)defaultSharingService;

+(BOOL)installScript:(NSString *)path;
+(void)addUserScriptsPath:(NSString *)path;
+(SendMailKitMessage *)messageWithSubject:(NSString *)subject body:(NSString *)body recipient:(NSString *)recipient attachment:(NSString *)attachment;
+ (SendMailKitMessage *)messageWithSubject:(NSString *)subject body:(NSString *)body recipient:(NSString *)recipient attachments:(NSArray *)attachments;
+(NSString *)temporaryDirectory;
+(NSMenu *)supportedMailClientsMenu;
-(NSString *)pluginsList;

@end
