on composeMailWithParameters(params)
	
	set email_recipient to (recipient of params)
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
	
	tell application "MailMate"
        activate
        
        set attachments to ""
        
        repeat with a_file in email_attachments
           set aURL to "&attachment-url=file:///" & my urlencode(a_file)
           set attachments to attachments & aURL
        end repeat
        
        set email_attachments to item 1 of email_attachments
        
        set sendstring to "mailto:" & email_recipient & "?subject=" & my urlencode(email_subject) & "&body="& my urlencode(email_content) &"&attachment-url=" & attachments
        open location sendstring with trust
	end tell
	
end composeMailWithParameters

on urlencode(str)
	local str
	try
		return (do shell script "/bin/echo " & quoted form of str & ¬
        " | perl -MURI::Escape -lne 'print uri_escape($_)'")
        on error eMsg number eNum
		error "Can't urlEncode: " & eMsg number eNum
	end try
end urlEncode

