on composeMailWithParameters(params)
	
	set email_recipient to (recipient of params)
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
	
	try
		tell application "Sparrow"
			activate
			
			set aMessage to make new outgoing message
			tell aMessage
				set subject to email_subject
				set content to my findAndReplace(return, "
", email_content)
				make new to recipient at beginning with properties {address:email_recipient}
                
                
                repeat with a_file in email_attachments
                    set aAttachment to make new mail attachment with properties {filename:a_file}
                end repeat
                
				compose
			end tell
		end tell
	end try
	
	
end composeMailWithParameters


on findAndReplace(tofind, toreplace, TheString)
	set ditd to text item delimiters
	set text item delimiters to tofind
	set textItems to text items of TheString
	set text item delimiters to toreplace
	if (class of TheString is string) then
		set res to textItems as string
	else -- if (class of TheString is Unicode text) then
		set res to textItems as Unicode text
	end if
	set text item delimiters to ditd
	return res
end findAndReplace
