on composeMailWithParameters(params)
    
    set email_recipients to (recipients of params)
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
    set email_sender to (sender of params)

    tell application id "it.bloop.airmail2"
		activate
		set email_content to my findAndReplace(return, "<br>", email_content)
		set theMessage to make new outgoing message with properties {subject:email_subject, content:email_content}
		tell theMessage
            if (email_sender is not "") then
                set sender to email_sender
            end if
			repeat with a_recipient in email_recipients
				make new to recipient at end of to recipients with properties {name: (name of a_recipient), address:(emailaddress of a_recipient)}
			end repeat
            
            repeat with a_file in email_attachments
                set aAttachment to make new mail attachment with properties {filename:a_file}
            end repeat

            compose
		end tell
	end tell
	
end composeMailWithParameters


on splitString(theString, theDelimiter)
	-- save delimiters to restore old settings
	set oldDelimiters to AppleScript's text item delimiters
	-- set delimiters to delimiter to be used
	set AppleScript's text item delimiters to theDelimiter
	-- create the array
	set theArray to every text item of theString
	-- restore the old setting
	set AppleScript's text item delimiters to oldDelimiters
	-- return the result
	return theArray
end splitString


on findAndReplace(tofind, toreplace, theString)
	set ditd to text item delimiters
	set text item delimiters to tofind
	set textItems to text items of theString
	set text item delimiters to toreplace
	if (class of theString is string) then
		set res to textItems as string
        else -- if (class of TheString is Unicode text) then
		set res to textItems as Unicode text
	end if
	set text item delimiters to ditd
	return res
end findAndReplace

