//
//  SupportKit.h
//  SupportKit
//
//  Created by Stefan on 2/23/13.
//  Copyright (c) 2013 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SupportKitWindowController;

extern NSString* const SupportKitMessageTypeNone;
extern NSString* const SupportKitMessageTypeGeneral;
extern NSString* const SupportKitMessageTypeProblem;
extern NSString* const SupportKitMessageTypeFeatureRequest;
extern NSString* const SupportKitMessageTypeFail;

@class SupportKit;

@protocol SupportKitDelegate <NSObject>
@optional
- (void) supportKit:(SupportKit *)kit willSend: (NSMutableDictionary *)dictionary;
- (void) supportKit:(SupportKit *)kit didSend: (NSMutableDictionary *)dictionary;
- (void) supportKit:(SupportKit *)kit didFailWithError: (NSError *)theError;

@end


@interface SupportKit : NSObject

@property (nonatomic,strong) SupportKitWindowController * windowController;
@property (nonatomic,strong) NSArray * supportedLanguages;
@property (nonatomic,strong) NSArray * messageTypes;
@property (nonatomic,strong) NSURL * suggestionsURL;
@property (nonatomic,strong) NSURL * postURL;
@property (nonatomic,strong) NSString * voteURLFormat;

@property (nonatomic) NSStringEncoding stringEncoding;

@property (nonatomic,strong) id<SupportKitDelegate> delegate;

@property (strong,nonatomic) NSOperationQueue * queue;

@property (nonatomic) NSInteger maximalLength;

@property (readonly, strong, nonatomic) NSPersistentStoreCoordinator *persistentStoreCoordinator;
@property (readonly, strong, nonatomic) NSManagedObjectModel *managedObjectModel;
@property (readonly, strong, nonatomic) NSManagedObjectContext *managedObjectContext;


+ (SupportKit *)sharedKit;
- (void)showWindow:(id)sender;
- (void)closeWindow:(id)sender;

- (NSString *)localizedSting:(NSString *)theKey;
- (NSString *)product;
- (NSString *)version;
-(void)voteForSuggestionID:(NSString *)string;


@end


