//
//  SFPrintColumn.h
//  TextRenderer
//
//  Created by Stefan Fuerst on 06.06.16.
//  Copyright (c) 2016 Stefan Fürst. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SFPrintMargins.h"


@interface SFPrintColumn : NSObject <NSCopying>

@property (nonatomic,strong) NSString * identifier; // theKey
@property (nonatomic) CGFloat width; // 0 = auto;
@property (nonatomic,strong) SFPrintMargins * margins;
@property (nonatomic,strong) NSFont * font;
@property (nonatomic,strong) NSColor * textColor;
@property (nonatomic,strong) NSValueTransformer * valueTransformer;
@property (nonatomic) NSTextAlignment textAlignment;
@property (nonatomic) NSImageAlignment imageAlignment;
@property (nonatomic) NSImageScaling imageScaling;
@property (nonatomic) CGFloat x;

+(SFPrintColumn *)columnWithIdentifier:(NSString *)key width:(CGFloat)width margins:(SFPrintMargins *)margins;
+(SFPrintColumn *)columnWithIdentifier:(NSString *)key width:(CGFloat)width;
+(SFPrintColumn *)columnWithIdentifier:(NSString *)key;
@end
