on composeMailWithParameters(params)
	
	set email_recipient to (recipient of params)
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
	
	tell application "Mail"
		activate
        set all_accounts to every account whose enabled is true
        set the_account to my getDefaultMailAccount()
        set the_adresses to email addresses of the_account
        set the_adress to item 1 of the_adresses
        set the_name to full name of the_account
        set the_adress to the_name & " <" & the_adress & ">"
        set the_font to message font
		set the_font_size to message font size
        if (number of signatures > 0) then
			set the_signature to signature 1
		end if
		set the_message to make new outgoing message with properties {subject:email_subject, content:"", visible:true, sender:the_adress}
        
		tell the_message
            set the_recipients to my splitString(email_recipient, ",")
			repeat with a_recipient in the_recipients
                make new to recipient at beginning of to recipients with properties {address:a_recipient}
			end repeat
		end tell
		
		tell the_message
            try
                repeat with a_file in email_attachments
                    make new attachment at end with properties {file name:a_file}
                end repeat
			end try
			set aPara to make new paragraph at beginning with data email_content & return & return
            set font of content to the_font
			set size of content to the_font_size
            -- important, otherwise signature will disapear again
            delay 1
			try
				set message signature to the_signature
			end try
		end tell
	end tell
	
end composeMailWithParameters


on getDefaultMailAccount()
	
	set mailaddress to ""
	try
		set mailaddress to do shell script "defaults read com.apple.mail-shared NewMessageFromAddress"
	end try
	
	tell application "Mail"
		set all_accounts to every account whose enabled is true
		repeat with myaccount in all_accounts
			set myaddresses to email addresses of myaccount
			repeat with myaddress in myaddresses
				if (mailaddress contains myaddress) then
					return myaccount
				end if
			end repeat
		end repeat
		repeat with myaccount in all_accounts
			if name of myaccount contains "Default" then
				return myaccount
			end if
		end repeat
		return first item of all_accounts
	end tell
	
end getDefaultMailAccount


on splitString(theString, theDelimiter)
	-- save delimiters to restore old settings
	set oldDelimiters to AppleScript's text item delimiters
	-- set delimiters to delimiter to be used
	set AppleScript's text item delimiters to theDelimiter
	-- create the array
	set theArray to every text item of theString
	-- restore the old setting
	set AppleScript's text item delimiters to oldDelimiters
	-- return the result
	return theArray
end splitString