on composeMailWithParameters(params)
	
	set email_recipient to (recipient of params)
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
	
	tell application "Mailplane 3"
		set m to make new outgoing message
		tell m
			set the_recipients to my splitString(email_recipient, ",")
			repeat with a_recipient in the_recipients
				set r to make new to recipient at end
				tell r
					set address to a_recipient
				end tell
			end repeat
			set subject to email_subject
			set content to email_content
			repeat with a_file in email_attachments
				if a_file is not "" then
					make new mail attachment with properties {path:a_file}
				end if
			end repeat
		end tell
		compose m
		activate
	end tell
	
end composeMailWithParameters

on splitString(theString, theDelimiter)
	-- save delimiters to restore old settings
	set oldDelimiters to AppleScript's text item delimiters
	-- set delimiters to delimiter to be used
	set AppleScript's text item delimiters to theDelimiter
	-- create the array
	set theArray to every text item of theString
	-- restore the old setting
	set AppleScript's text item delimiters to oldDelimiters
	-- return the result
	return theArray
end splitString