//
//  SKChangeSet.h
//  SyncKit3
//
//  Created by Stefan on 30.03.15.
//  Copyright (c) 2015 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SKDevice;
@class SKManagedObjectContext;

@interface SKChangeSet : NSObject


@property (nonatomic,strong) SKDevice * device;
@property (nonatomic,strong) NSDate * dateStamp;

+(SKChangeSet *)changeSetFromDictionary:(NSDictionary *)changes;
+(SKChangeSet *)changeSetForManagedObjectContext:(SKManagedObjectContext *)context;
+(SKChangeSet *)fullSetForManagedObjectContext:(SKManagedObjectContext *)context;
+(SKChangeSet *)changeSetForManagedObjects:(NSArray *)objects inContext:(SKManagedObjectContext *)context;

-(NSMutableDictionary *)changes;

-(NSInteger)count;
-(void)write;

@end
