//
//  SKManagedObjectContext.h
//  SyncKit3
//
//  Created by Stefan on 30.03.15.
//  Copyright (c) 2015 Media Atelier. All rights reserved.
//

#import <CoreData/CoreData.h>
#import "SKChangeSet.h"
#import "SKRepository.h"
#import "SKDevice.h"
#import "SKConnection.h"
#import "SKLogger.h"
#import "NSManagedObject+SyncKit3.h"

extern NSString * SKSyncHasFinished;
extern NSString * SKSyncHasWrittenLocalChanges;


@protocol SKManagedObjectContextDelegate;


@interface SKManagedObjectContext : NSManagedObjectContext <NSOpenSavePanelDelegate>

@property (nonatomic,weak) id<SKManagedObjectContextDelegate> skDelegate;
@property (nonatomic,assign) BOOL syncing;

@property (nonatomic,assign) BOOL merging;
@property (nonatomic,assign) BOOL restoring;
@property (nonatomic,assign) BOOL ignoreErrors;
@property (nonatomic,strong) NSDate * lastWriteDate;

@property (nonatomic,strong) SKRepository * repository;
@property (nonatomic,strong) SKDevice * device;
@property (nonatomic,strong) SKConnection * connection;
@property (nonatomic,strong) NSArray * defaultObjects;

@property (nonatomic,strong) NSString * syncIdentifier;
@property (nonatomic,strong) NSString * syncDeviceID;
@property (nonatomic,strong) SKLogger * logger;

@property (nonatomic) dispatch_queue_t _syncQueue;
@property (nonatomic,strong) NSDictionary * serverDictionary;
@property (nonatomic,strong) NSManagedObjectContext * syncContext;
@property (nonatomic,strong) NSArray * backupTypes;

#pragma mark init

-(SKManagedObjectContext *)initWithConcurrencyType:(NSManagedObjectContextConcurrencyType)ct syncIdentifier:(NSString *)syncIdentifier;
-(SKManagedObjectContext *)commonInit;
-(NSString *)syncRoot;

#pragma mark actions

-(BOOL)initialSave;
-(BOOL)saveWithoutSync:(NSError *__autoreleasing *)error;
-(void)advanceRepositoryWithAlert:(id)sender;
-(void)advanceRepository:(id)sender;
-(void)syncHasFinished;
-(void)reloadSyncLog:(id)sender;
-(NSInteger)modelVersion;
-(void)showLogger:(id)sender;
-(NSURL *)createBackup:(NSString *)fileExtension;
-(NSURL *)createBackup:(NSString *)fileExtension info:(NSDictionary *)dictionary;
-(void)restoreBackup:(NSString *)fileExtension;
-(void)restoreBackup:(NSString *)extension types:(NSArray *)types;
-(BOOL)openBackupFile:(NSString *)path;
-(NSMutableDictionary *)infoDictionary;
-(NSString *)infoDictionaryString;
-(void)processOpenBackup:(NSURL *)URL info:(NSDictionary *)info;
-(void)createAdditionalBackups:(NSURL *)theURL context:(NSManagedObjectContext *)context;
-(NSMutableDictionary *)compareDictionary;
-(NSString *)checkSum;
-(void)receivedRemoteChanges;
-(NSArray *)changeLogForUID:(NSString *)theUID;
-(void)deflate:(id)sender;
-(void)advanceAndDeflate:(id)sender;

@end

@protocol SKManagedObjectContextDelegate <NSObject>

@optional
-(NSArray *)defautObjectsForContext:(SKManagedObjectContext *)context;

@end
