//
//  SFCSVImporter.h
//  XLBridge
//
//  Created by Stefan Fuerst on 19.05.16.
//  Copyright (c) 2016 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>

@class XLBook;
@class XLSheet;
@class SFCSVImporterViewController;
@protocol SFCSVImporterDelegate;



@interface SFCSVImporter : NSObject

@property (nonatomic,strong) NSString * lineSeparator;
@property (nonatomic,strong) NSString * itemSeparator;
@property (nonatomic) NSStringEncoding encoding;
@property (nonatomic,strong) NSString * rawString;
@property (nonatomic,strong) NSArray * lines;
@property (nonatomic,strong) XLBook * xlBook;
@property (nonatomic,strong) XLSheet * xlSheet;
@property (nonatomic,weak) id <SFCSVImporterDelegate> delegate;
@property (nonatomic,weak) SFCSVImporterViewController * controller;


+(SFCSVImporter *)importerWithContentsOfFile:(NSString *)path controller:(SFCSVImporterViewController *)controller delegate:(id <SFCSVImporterDelegate>) delegate;

+(SFCSVImporter *)importerWithString:(NSString *)string controller:(SFCSVImporterViewController *)controller delegate:(id <SFCSVImporterDelegate>) delegate;

+(SFCSVImporter *)importerWithPasteboard:(NSPasteboard *)pasteboard controller:(SFCSVImporterViewController *)controller delegate:(id <SFCSVImporterDelegate>) delegate;


@end
