//
//  XLSheet.h
//  XLBridge
//
//  Created by Stefan on 21.12.14.
//  Copyright (c) 2014 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
//#import "libxl.h"
#import "XLBook.h"

@interface XLSheet : NSObject

@property SheetHandle sheetHandle;
@property (assign) XLBook * book;
@property (strong) NSString * title;

- (instancetype)initWithBook:(XLBook *)thebook andTitle:(NSString *)theTitle;

+(NSString *)columnName:(NSInteger)columnNum;
-(void)setRow:(NSInteger)row andColumn:(NSInteger)column toValue:(id)value;
-(void)setRow:(NSInteger)row andColumn:(NSInteger)column toFontStyle:(NSInteger)styleMask;
-(void)setRow:(NSInteger)row andColumn:(NSInteger)column toBackgroundColor:(NSColor *)color;
-(void)setRow:(NSInteger)row andColumn:(NSInteger)column toTextAlignment:(NSTextAlignment)textAlignment;
-(void)setRow:(NSInteger)row toFontStyle:(NSInteger)styleMask;
-(void)setRow:(NSInteger)row toBackgroundColor:(NSColor *)color;
-(void)setRow:(NSInteger)row toTextAlignment:(NSTextAlignment)textAlignment;
-(void)setColumn:(NSInteger)column toBackgroundColor:(NSColor *)color;
-(void)setColumn:(NSInteger)column toFontStyle:(NSInteger)styleMask;
-(void)setColumn:(NSInteger)column toTextAlignment:(NSTextAlignment)textAlignment;

-(void)setValueArray:(NSArray *)array;
-(void)autoFitColumns;
-(void)setRowHeight:(double)theHeight;
-(NSInteger)lastRowIndex;
-(NSInteger)lastColumnIndex;
-(NSInteger)numberOfRows;
-(NSInteger)numberOfColumns;
-(NSMutableArray *)valueArray;
-(NSMutableArray *)stringArray;

@end




