//
//  SKDevice.h
//  SyncKit3
//
//  Created by Stefan on 31.03.15.
//  Copyright (c) 2015 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SKChangeSet.h"
#import "SKConnection.h"

@class SKRepository;

@interface SKDevice : NSObject

@property (nonatomic,weak) SKRepository * repository;
@property (nonatomic,strong) NSDictionary * info;
@property (nonatomic,strong) NSString * uid;
@property (nonatomic,strong) NSArray * remoteChanges;
@property (nonatomic) BOOL isLocalDevice;
@property (nonatomic,strong) NSDate * mostPastDate;

-(NSString *)path;
-(NSString *)logPath;
-(NSString *)logIndexPath;
-(NSString *)logIndexDeltaPath;
-(NSString *)deviceInfoPath;
-(BOOL)logExists;

-(NSArray *)changeLogForUID:(NSString *)theUID;
-(void)writeChanges:(SKChangeSet *)changes;
-(void)setup;
-(void)createUserInfo;
-(void)createVersionInfo;
-(void)uploadChanges;
-(void)readMostPastDate;
-(NSArray *)loadChangesFromDate:(NSDate *)date;
-(NSMutableDictionary *)infoDictionary;


@end
