//
//  SFCSVImporterMapper.h
//  XLBridge
//
//  Created by Stefan Fuerst on 21.05.16.
//  Copyright (c) 2016 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum SFCSVImporterType : NSUInteger{
   SFCSVImporterTypeString,
   SFCSVImporterTypeDate,
   SFCSVImporterTypeNumber,
   SFCSVImporterTypeDecimalNumber,
   SFCSVImporterTypeCustom
} SFCSVImporterType;

@interface SFCSVImporterMapper : NSObject
+(SFCSVImporterMapper *)mapperForKey:(NSString *)key withDisplayName:(NSString *)name;
+(SFCSVImporterMapper *)mapperForKey:(NSString *)key withDisplayName:(NSString *)name andType:(SFCSVImporterType)type;
-(BOOL)import;
-(id)convert:(id)input;
-(void)addValue:(id)input to:(NSMutableDictionary *)dictionary;

@property (nonatomic,strong) NSString * key;
@property (nonatomic,strong) NSString * displayName;
@property (nonatomic) SFCSVImporterType type;
@property (nonatomic,strong) NSMutableArray * _dateFormatters;

@end


@interface SFCSVNoImporterMapper : SFCSVImporterMapper
@end



