//
//  XLBook.h
//  XLBridge
//
//  Created by Stefan on 21.12.14.
//  Copyright (c) 2014 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <LibXL/libxl.h>

@class XLSheet;

@interface XLBook : NSObject

@property BookHandle bookHandle;
@property FormatHandle dateFormatHandle;
@property FormatHandle dateTimeFormatHandle;

@property FormatHandle numberFormatHandle;
@property FormatHandle durationFormatHandle;
@property FormatHandle defaultFormatHandle;

@property BOOL isXML;
@property (strong) NSMutableArray * sheets;
@property (strong,nonatomic) NSLocale * locale;
@property (strong,nonatomic) NSFont * font;

-(instancetype)initWithXML:(BOOL)useXML;
-(instancetype)initWithContentsOfFile:(NSString *)path;
-(XLSheet *)addSheetWithTitle:(NSString *)theTitle;
-(void)writeToFile:(NSString *)thePath;
-(NSData *)dataRepresentation;
-(NSString *)fileExtension;
-(NSInteger)indexForColor:(NSColor *)color;
-(XLSheet *)firstSheet;
-(XLSheet *)sheetTitled:(NSString *)name;

@end
