/* 
  SFPrintDocumentDelegate.h
  PrintKit

  Created by Stefan Fuerst on 12.06.16.
  Copyright (c) 2016 Stefan Fürst. All rights reserved.
*/

@class SFPrintDocument;
@class SFPrintPageView;
@class SFPrintMargins;
@class SFPrintRowView;
@class SFPrintDocumentSection;


@protocol SFPrintDocumentDelegate <NSObject>
@optional
-(void)printDocument:(SFPrintDocument *)document didFinishRenderingPages:(NSArray *)array;
-(void)printDocument:(SFPrintDocument *)document didAddSection:(SFPrintDocumentSection *)section;
-(void)printDocument:(SFPrintDocument *)document presentProgressWindow:(NSWindow *)window;
-(void)printDocument:(SFPrintDocument *)document dismissProgressWindow:(NSWindow *)window;

@end


@protocol SFPrintDocumentSectionDelegate <NSObject>
@optional
-(SFPrintMargins *)printDocument:(SFPrintDocument *)document pageMarginsForPageIndex:(NSInteger)index;
-(void)printDocument:(SFPrintDocument *)document didAddPageView:(SFPrintPageView *)pageView;
-(void)printDocument:(SFPrintDocument *)document willAddRowView:(SFPrintRowView *)rowView;
-(void)printDocument:(SFPrintDocument *)document didAddRowView:(SFPrintRowView *)rowView;
-(void)printDocument:(SFPrintDocument *)document didRejectRowView:(SFPrintRowView *)rowView;
-(CGFloat)printDocument:(SFPrintDocument *)document heightForRowView:(SFPrintRowView *)rowView;
-(NSArray *)printDocument:(SFPrintDocument *)document columnsForValues:(NSDictionary *)values inPageView:(SFPrintPageView *)pageView;
-(NSDictionary *)printDocument:(SFPrintDocument *)document valuesForValues:(NSDictionary *)values inPageView:(SFPrintPageView *)pageView;
-(BOOL)printDocument:(SFPrintDocument *)document shouldInsertPageBreakBeforeValues:(NSDictionary *)values inPageView:(SFPrintPageView *)pageView;
-(BOOL)printDocument:(SFPrintDocument *)document shouldInsertPageBreakAfterValues:(NSDictionary *)values inPageView:(SFPrintPageView *)pageView;
-(NSArray *)printDocument:(SFPrintDocument *)document headerColumnsForPageIndex:(NSInteger)index;
-(NSDictionary *)printDocument:(SFPrintDocument *)document headersForPageIndex:(NSInteger)index;
-(void)printDocument:(SFPrintDocument *)document didFinishRenderingPages:(NSArray *)array;

@end

