//
//  PTKDocument.h
//  PDFToolKit
//
//  Created by Stefan Fuerst on 22.09.17.
//  Copyright (c) 2017 Media Atelier. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Quartz/Quartz.h>
#import "PDFToolKitPDFDocumentAttachment.h"

typedef enum {
    kPDFNoVariant,
    kPDFA1a,
    kPDFA2a,
    kPDFA3a
} PTKVariant;

@interface PDFToolKitPDFDocument : PDFDocument
@property (nonatomic,assign) BOOL optimize;
@property (nonatomic,assign) BOOL allowVariantDowngrade;
@property (nonatomic,assign) BOOL needsOptimize;
@property (nonatomic,assign) PTKVariant variant;
@property (nonatomic,strong) NSMutableArray * attachments;
@property (nonatomic,strong) NSMutableArray * fonts;
@property (nonatomic,strong) NSMutableArray * transcript;
@property (nonatomic,strong) NSData * rawData;

-(void)addAttachment:(PDFToolKitPDFDocumentAttachment *)attachment;
@end
