//
//  FSCompatibility.h
//  SyncKit3
//
//  Created by Stefan on 08.04.15.
//  Copyright (c) 2015 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SKManagedObjectContext.h"
#import "SKConnection.h"
#import "SKLocalDropboxConnection.h"
#import "SKHostedWebDavServiceConnection.h"
#import "SKBase.h"


extern NSString * FSManagedObjectContextDidMergeExternalChangesNotification;

@interface FSManagedObjectContext : SKManagedObjectContext

-(BOOL)isSyncing;
- (BOOL) saveAndSync:(BOOL)sync error:(NSError**)error;
-(BOOL)saveAndSync:(BOOL)sync;
- (void) createNewRepositoryCompletion:(void(^)())completion;
- (void) restoreFromRepositoryCompletion:(void(^)())completion;
-(void) restoreFromDate:(NSDate *)theDate completion:(void(^)())completion;



@end


@interface FSConnection : SKConnection

@end


@interface FSLocalDropboxConnection  : SKLocalDropboxConnection

@end


@interface FSHostedWebDavServiceConnection  : SKHostedWebDavServiceConnection

@end


@interface FSBase : SKBase

@end