//
//  SKConnection.h
//  SyncKit3
//
//  Created by Stefan on 31.03.15.
//  Copyright (c) 2015 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SKPushService.h"


typedef enum {
    kSKConnectionValidationNoError,
    kSKConnectionValidationNoInternetConnectionError,
    kSKConnectionValidationAuthenticationError,
    kSKConnectionValidationServerError
} SKConnectionValidationError;


@class SKManagedObjectContext;

@interface SKConnection : NSObject

@property (nonatomic, strong) NSString* syncIdentifier;
@property (nonatomic) SKManagedObjectContext * managedObjectContext;

-(NSDictionary *)loadServerDictionary;

- (id)initWithCoder:(NSCoder *)decoder;
- (void)encodeWithCoder:(NSCoder *)encoder;
- (NSMutableDictionary *) directoryContentsAtURL:(NSURL *)theURL error:(NSError**)error;
- (NSMutableDictionary *) directoryContentsAtURL:(NSURL *)theURL depth:(NSInteger)theDepth error:(NSError**)error;
- (BOOL) createDirectory:(NSURL *)theURL;
- (BOOL) removeURL:(NSURL *)theURL;
- (BOOL) appendFile:(NSString *)thePath toURL:(NSURL *)theURL;
- (BOOL) appendURL:(NSURL *)theURL toFile:(NSString *)thePath;
- (NSURL*)serviceURL;
- (void)notifyChanges;
- (NSMutableDictionary *)pushIdentityInfo;
-(void)pushReceived:(NSNotification *)not;
- (BOOL) isValidWithInfo:(NSDictionary**)validationInfo error:(SKConnectionValidationError*)outError;
-(NSMutableDictionary *)infoDictionary;


@end
