/*
	Variables:
	
	document the GrandTotal document formed like the clipboard representation 
	
*/



createFile();


function createFile()
{

	var source = {
  		_name: 'rsm:CrossIndustryDocument',
  		_attrs: {
    		'xmlns:xsi': 'http://www.w3.org/2001/XMLSchema-instance',
    		'xmlns:rsm': 'urn:ferd:CrossIndustryDocument:invoice:1p0', 
    		'xmlns:ram': 'urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:12',
    		'xmlns:udt': 'urn:un:unece:uncefact:data:standard:UnqualifiedDataType:15'
 		 },
 		 _content: []
 	}
 	 	
 	
 	var header = {
 		_name: 'rsm:HeaderExchangedDocument',
 		_content: [
 			{
 				_name: 'ram:ID',
 				_content: document["name"]
 			},
 			{
 				_name: 'ram:Name',
 				_content: document["label"]
 			},
 			{
 				_name: 'ram:TypeCode',
 				_content: 380
 			},
 			{
 				_name: 'ram:IssueDateTime',
 				_content: makeDateTime(document["dateSent"])
 			},
 			{
 				_name: 'ram:IncludedNote',
 				_content: [
 					{
 						_name: 'ram:Content',
 						_content: document["conditions"]
 					}
 				]
 			}
 		]
 	}
 	
 	var context = {
  		_name: 'rsm:SpecifiedExchangedDocumentContext',
 		_content: [
 			{
 				_name: 'ram:GuidelineSpecifiedDocumentContextParameter',
 				_content: [
 					{
 						_name: 'ram:ID',
 						_content: 'urn:ferd:CrossIndustryDocument:invoice:1p0:comfort'
 					}
 				]
 			}
 		]
 	}
 	
 	var seller = makeTradeParty(document["sender"],"SellerTradeParty");
 	var recipient = makeTradeParty(document["recipient"],"BuyerTradeParty");
 	
 	
 	var agreementItems = [seller,recipient];
 	
 	if (document["reference"])
 	{
 	    var order = {
			_name: 'ram:BuyerOrderReferencedDocument',
			_content: [
				{
					_name: 'ram:IssueDateTime',
					_content: makeISOTime(document["dateSent"])
				},
				{
					_name: 'ram:ID',
					_content: document["reference"]
				}
			]
		}
 		agreementItems.push(order);
 	}
 	
 	
 	
 	
 	var supplyChainTradeSettlement = {
		_name: 'ram:ApplicableSupplyChainTradeSettlement',
		_content: [
			{
				_name: 'ram:InvoiceCurrencyCode',
				_content: document["currency"]
			},
			{
				_name: 'ram:SpecifiedTradeSettlementPaymentMeans',
				_content: [
					{
						_name: 'ram:PayeePartyCreditorFinancialAccount',
						_content: [
							{
								_name: 'ram:IBANID',
								_content: document["sender"]["IBAN"]
							}
						]
					},
					{
						_name: 'ram:PayeeSpecifiedCreditorFinancialInstitution',
						_content: [
							{
								_name: 'ram:BICID',
								_content: document["sender"]["BIC"]
							}
						]
					}
				]
			}
		]
	}
	
 	var taxes = makeTaxes(document["taxes"]);
 	
 	supplyChainTradeSettlement["_content"].push(taxes);
 	
 	var values = {
 		_name: 'ram:SpecifiedTradeSettlementMonetarySummation',
 		_content : [
 			{
 				_name: 'ram:LineTotalAmount',
 				_attrs: {currencyID: document["currency"]},
 				_content: document["netAsString"]
 			},
 			{
 				_name: 'ram:ChargeTotalAmount',
 				_attrs: {currencyID: document["currency"]},
 				_content: 0
 			},
 			{
 				_name: 'ram:AllowanceTotalAmount',
 				_attrs: {currencyID: document["currency"]},
 				_content: 0
 			},
 			{
 				_name: 'ram:TaxBasisTotalAmount',
 				_attrs: {currencyID: document["currency"]},
 				_content: document["taxedNetAsString"]
 			},
 			{
 				_name: 'ram:TaxTotalAmount',
 				_attrs: {currencyID: document["currency"]},
 				_content: document["taxAsString"]
 			},
 			{
 				_name: 'ram:GrandTotalAmount',
 				_attrs: {currencyID: document["currency"]},
 				_content: document["grossAsString"]
 			}
 		]
 	}
 	
 	supplyChainTradeSettlement["_content"].push(values);

 	
 	var supplyChain = {
 		_name: 'rsm:SpecifiedSupplyChainTradeTransaction',
		_content: [
 			{
 				_name: 'ram:ApplicableSupplyChainTradeAgreement',
 				_content: agreementItems
 			},
 			{
 				_name: 'ram:ApplicableSupplyChainTradeDelivery',
 				_content: [
 					{
 						_name : 'ram:ActualDeliverySupplyChainEvent',
 						_content: [
 							{
 								_name: 'ram:OccurrenceDateTime',
								_content: makeDateTime(document["dateSent"])
 							}
 						]
 					}
 				]
 			},
 			supplyChainTradeSettlement
 		]
 	}
 	
 	
 
 	
 	
 	
 	appendTradeItems(document,supplyChain["_content"]);

 	
 	
 	
 	source["_content"] = [context,header,supplyChain];
 	
	var content = toXML(source,{header: true, indent: '  '});

	var result = {};
	result["files"] = [{
		"destination" : "pdf",
		"type" : "zugferd",
		"content" : content,
		"name" : "ZUGFeRD-invoice.xml"
	}];
	return result;
}



function appendTradeItems(document,theArray)
{
	input = document["items"];

	for (i=0;i<input.length;i++)
	{
		var aItem = input[i];
				

		var aTradeItem = {
			_name: 'ram:IncludedSupplyChainTradeLineItem',
			_content : [
				{
					_name: 'ram:AssociatedDocumentLineDocument',
					_content: [
						{
							_name: 'ram:LineID',
							_content: i+1
						}
					]
				},
				{
					_name: 'ram:SpecifiedSupplyChainTradeDelivery',
					_content: [
						{
							_name: 'ram:BilledQuantity',
							_attrs: {unitCode: "C62"},
							_content: aItem["quantity"]
						},
						{
							_name: 'ram:SpecifiedSupplyChainTradeDelivery',
							_content: [
								{
									_name: 'ram:ActualDeliverySupplyChainEvent',
									_content: [
										{
											_name: 'ram:OccurrenceDateTime',
											_content: makeDateTime(aItem["date"])
										}
									]
								}
							]
						}
						
						
					]				
				},
				{
					_name: 'ram:SpecifiedSupplyChainTradeSettlement',
					_content: [
						{
							_name: 'ram:ApplicableTradeTax',
							_content: [
								{
									_name: 'ram:TypeCode',
									_content: 'VAT'
								},
								{
									_name: 'ram:CategoryCode',
									_content: 'S'
								},
								{
									_name: 'ram:ApplicablePercent',
									_content: aItem["taxPercentageAsString"]
								}
							]
						},
						{
							_name: 'ram:SpecifiedTradeSettlementMonetarySummation',
							_content: [
								{
									_name: 'ram:LineTotalAmount',
									_attrs: {currencyID: document["currency"]},
									_content: aItem["netAsString"]
								}
							]
						}
					]	
				},
				{
					_name: 'ram:SpecifiedTradeProduct',
					_content: [
						{
							_name: 'ram:Name',
							_content: aItem["name"] 
						}/*,
						{
							_name: 'ram:ApplicableProductCharacteristic',
							_content: [
								{
									_name: 'ram:Description',
									_content: aItem["description"] 
								}
							] 
						}*/
						
						
						
					]
				}
			]
		}
		theArray.push(aTradeItem);
	}	
}


function makeTaxes(input)
{
	result = [];
	for (i=0;i<input.length;i++)
	{
		var aItem = input[i];
		var aTax = {
			_name: 'ram:ApplicableTradeTax',
			_content : [
				{
					_name: 'ram:TypeCode',
					_content: 'VAT'				
				},
				{
					_name: 'ram:CalculatedAmount',
					_attrs: {currencyID: aItem["currency"]},
					_content: aItem["taxAsString"]
				},
				{
					_name: 'ram:BasisAmount',
					_attrs: {currencyID: aItem["currency"]},
					_content: aItem["netAsString"]
				},
				{
					_name: 'ram:ApplicablePercent',
					_content: aItem["rateAsString"]
				}
			]
		}
		result.push(aTax);
		
	}	
	return result;
}


function makeTradeParty(party,name)
{

	var personname = "";
	
	if (party["firstName"])
	{
		personname = personname + party["firstName"];
	}
	if (party["lastName"])
	{
		if (party["firstName"]) {
			personname = personname + " ";
		}
		personname = personname + party["lastName"];
	}
	
	return {
		_name: 'ram:'+ name,
		_content : [
			{
				_name: 'ram:Name',
				_content: party["name"]
			},
			{
				_name: 'ram:PostalTradeAddress',
				_content: [
					{
						_name: 'ram:PostcodeCode',
						_content: party["zip"]
					},
					{
						_name: 'ram:LineOne',
						_content: party["street"]
					},
					{
						_name: 'ram:CityName',
						_content: party["city"]
					},
					{
						_name: 'ram:CountryID',
						_content: party["countryCode"]
					}
				]
			},
			{
				_name: 'ram:DefinedTradeContact',
				_content: [
					{
						_name: 'ram:DepartmentName',
						_content: party["department"]
					},
					{
						_name: 'ram:PersonName',
						_content: personname
					}
					
				]
			},
			{
				_name: 'ram:SpecifiedTaxRegistration',
				_content: [
					{
						_name: 'ram:ID',
						_content: party["VATID"],
						_attrs: {
    						'schemeID': 'VA'
    					}
					}
				
				]
			}
			
		]
	} 
} 


function makeISOTime(input)
{
   var yyyy = input.getFullYear().toString();
   var mm = (input.getMonth()+1).toString(); // getMonth() is zero-based
   var dd  = input.getDate().toString();
   var date = yyyy + "-" + (mm[1]?mm:"0"+mm[0]) + "-" + (dd[1]?dd:"0"+dd[0]); // padding
   date = date + "T00:00:00";
   return date;
}


function makeDateTime(input)
{

	if (!input) {
		return {};
	}
   var yyyy = input.getFullYear().toString();
   var mm = (input.getMonth()+1).toString(); // getMonth() is zero-based
   var dd  = input.getDate().toString();
   var date = yyyy + "" + (mm[1]?mm:"0"+mm[0]) + "" + (dd[1]?dd:"0"+dd[0]); // padding
   
	return {
		_name: 'udt:DateTimeString',
		_attrs: {
			format: 102
		},
		_content : date
	}
}



/*
The MIT License (MIT)
Copyright (c) 2014 by David Calhoun (david.b.calhoun@gmail.com).
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


function escapeXml(unsafe) {
    return unsafe.replace(/[<>&'"]/g, function (c) {
        switch (c) {
            case '<': return '&lt;';
            case '>': return '&gt;';
            case '&': return '&amp;';
            case '\'': return '&apos;';
            case '"': return '&quot;';
        }
    });
}

function toXML(obj, config)
{
  // include XML header
  config = config || {};
  var out = '';
  if(config.header) {
    if(typeof config.header == 'string') {
      out = config.header;
    } else {
      out = '<?xml version="1.0" encoding="UTF-8"?>\n';
    }
  }
  
  var origIndent = config.indent || '';
  var indent = '';
  var concat = ',';

  var filter = function customFilter(txt) {
    if(!config.filter) return txt;
    var mappings = config.filter;
    var replacements = [];
    for(var map in mappings) {
      if(!mappings.hasOwnProperty(map)) continue;
      replacements.push(map);
    }
    return String(txt).replace(new RegExp('(' + replacements.join('|') + ')', 'g'), function(str, entity) {
      return mappings[entity] || '';
    });
  };
  
  // helper function to push a new line to the output
  var push = function(string){
    out += string + (origIndent ? '\n' : '');
  };
  
  /* create a tag and add it to the output
     Example:
     outputTag({
       name: 'myTag',      // creates a tag <myTag>
       indent: '  ',       // indent string to prepend
       closeTag: true,     // starts and closes a tag on the same line
       selfCloseTag: true,
       attrs: {            // attributes
         foo: 'bar',       // results in <myTag foo="bar">
         foo2: 'bar2'
       }
     });
  */
  var outputTag = function(tag){
    var attrsString = '';
    var outputString = '';
    var attrs = tag.attrs || '';
    
    // turn the attributes object into a string with key="value" pairs
    for(var attr in attrs){
      if(attrs.hasOwnProperty(attr)) {
        attrsString += ' ' + attr + '="' + attrs[attr] + '"';
      }
    }

    // assemble the tag
    outputString += (tag.indent || '') + '<' + (tag.closeTag ? '/' : '') + tag.name + (!tag.closeTag ? attrsString : '') + (tag.selfCloseTag ? '/' : '') + '>';
    
    // if the tag only contains a text string, output it and close the tag
    if(tag.text || tag.text === ''){
      outputString += filter(tag.text) + '</' + tag.name + '>';
    }
    
    push(outputString);
  };
  
  // custom-tailored iterator for input arrays/objects (NOT a general purpose iterator)
  var every = function(obj, fn, indent){
    // array
    //console.log(Array.isArray(obj))
    if(Array.isArray(obj)){
      obj.every(function(elt){  // for each element in the array
        fn(elt, indent);
        return true;            // continue to iterate
      });
      
      return;
    }
    
    // object with tag name
    if(obj._name){
      fn(obj, indent);
      return;
    }
    
    // iterable object
    for(var key in obj){
      var type = typeof obj[key];
      if(obj.hasOwnProperty(key) && (obj[key] || type === 'boolean' || type === 'number')){
        fn({_name: key, _content: obj[key]}, indent);
      //} else if(!obj[key]) {   // null value (foo:'')
      } else if(obj.hasOwnProperty(key) && obj[key] === null) {   // null value (foo:null)
        obj[key] = 'null';
        fn({_name: key, _content: obj[key]}, indent);       // output the keyname as a string ('foo')
      } else if(obj.hasOwnProperty(key) && obj[key] === '') {
        // blank string
        outputTag({
          name: key,
          text: ''
        });
      }
    }
  };
  
  var convert = function convert(input, indent){
    var type = typeof input;
    if(!indent) indent = '';
    if(Array.isArray(input)) type = 'array';
    
    var path = {
      'string': function(){
        push(indent + filter(escapeXml(input)) + ',');
      },

      'boolean': function(){
        push(indent + (input ? 'true' : 'false'));
      },
      
      'number': function(){
        push(indent + input);
      },
      
      'array': function(){
        every(input, convert, indent);
      },
      
      'function': function(){
        push(indent + input());
      },
      
      'object': function(){
        if(!input._name){
          every(input, convert, indent);
          return;
        }
        
        var outputTagObj = {
          name: input._name,
          indent: indent,
          attrs: input._attrs
        };
        
        var type = typeof input._content;

        if(type === 'undefined' || input._content._selfCloseTag === true){
          if (input._content && input._content._attrs) {
            outputTagObj.attrs = input._content._attrs;
          }
          outputTagObj.selfCloseTag = true;
          outputTag(outputTagObj);
          return;
        }
        
        var objContents = {
          'string': function(){
            outputTagObj.text = escapeXml(input._content);
            outputTag(outputTagObj);
          },

          'boolean': function(){
            outputTagObj.text = (input._content ? 'true' : 'false');
            outputTag(outputTagObj);
          },
          
          'number': function(){
            outputTagObj.text = input._content.toString();
            outputTag(outputTagObj);
          },
          
          'object': function(){  // or Array
            outputTag(outputTagObj);
            every(input._content, convert, indent + origIndent);
            
            outputTagObj.closeTag = true;
            outputTag(outputTagObj);
          },
          
          'function': function(){
            outputTagObj.text = input._content();  // () to execute the fn
            outputTag(outputTagObj);
          }
        };
        
        if(objContents[type]) objContents[type]();
      }
      
    };
    
    if(path[type]) path[type]();
  };
  
  convert(obj, indent);
  
  return out;
};



