//
//  CoreDataBrowser.h
//  CoreDataBrowser
//
//  Created by Stefan on 18.12.12.
//  Copyright (c) 2012 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface CoreDataBrowser : NSObject <NSWindowDelegate, NSMenuDelegate>


@property (strong,nonatomic) NSManagedObjectContext * managedObjectContext;
@property (strong) NSMutableSet * windowControllers;
@property (strong) NSMenuItem * menuItem;
@property (strong) NSMenu * menu;
@property (assign,nonatomic) SEL action;


+ (CoreDataBrowser *)sharedBrowser;
-(void)installMenu;
-(void)removeMenu;
-(void)openWindowForEntityName:(NSString *)entityName withObjects:(NSArray *)objects;
-(void)openWindowForEntityName:(NSString *)entityName;


@end


@interface NSObject (CoreDataBrowser);
+(NSDictionary *)coreDataBrowserAttributesByName;
+(NSDictionary *)coreDataBrowserAccessors;
@end


@interface CDBAttributeDescription : NSAttributeDescription
+(CDBAttributeDescription *)attributeWithName:(NSString *)name andType:(NSAttributeType)type;
@end