//
//  SFPrintPageView.h
//  TextRenderer
//
//  Created by Stefan Fuerst on 06.06.16.
//  Copyright (c) 2016 Stefan Fürst. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SFPrintDocument;
@class SFPrintMargins;
@class SFPrintDocumentSection;

@interface SFPrintPageView : NSView

@property (assign, nonatomic) SFPrintDocument * document;
@property (nonatomic, strong) SFPrintDocumentSection * section;

@property (assign, nonatomic) NSInteger index;
@property (strong, nonatomic) NSMutableArray * columns;
@property (strong, nonatomic) NSMutableArray * rows;
@property (strong, nonatomic) SFPrintMargins * margins;

-(NSArray *)addValues:(NSArray *)array;
-(NSRect)innerRect;
-(NSRect)rowsRect;
-(CGFloat)remainingHeight;
-(CGFloat)rowHeightForValues:(NSMutableDictionary *)dictionary;
-(NSRect)rectForColumnIdentifier:(NSString *)identifier;
-(NSRect)rectInCorner:(NSInteger)alignment ofSize:(NSSize)size;

@end



@interface NSArray (Subarray)

-(NSArray *)SFPrintSubArrayFromIndex:(NSInteger)index;

@end
