on composeMailWithParameters(params)
	
	set email_recipients to (recipients of params)
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
	set email_sender to (sender of params)
	
	
	tell application "Mail"
		activate
		try
			set all_accounts to every account whose enabled is true
		on error
			set all_accounts to every account
		end try
		set the_account to my getDefaultMailAccount(email_sender)
		set the_adresses to email addresses of the_account
		set the_adress to item 1 of the_adresses
		set the_name to full name of the_account
		set the_adress to the_name & " <" & the_adress & ">"
		set the_font to message font
		set the_font_size to message font size
		if (number of signatures > 0) then
			set the_signature to signature 1
		end if
		set the_message to make new outgoing message with properties {subject:email_subject, content:"", visible:true, sender:the_adress}
		
		tell the_message
			
			repeat with a_recipient in email_recipients
				set a_name to (name of a_recipient)
				set a_address to (emailaddress of a_recipient)
				make new to recipient at beginning of to recipients with properties {address:a_address, name:a_name}
			end repeat
		end tell
		
		tell the_message
			try
				repeat with a_file in email_attachments
					make new attachment at end with properties {file name:a_file}
				end repeat
			end try
			set aPara to make new paragraph at beginning with data email_content & return & return
			set font of content to the_font
			set size of content to the_font_size
			-- important, otherwise signature will disapear again
			delay 1
			try
				set message signature to the_signature
			end try
		end tell
	end tell
	
end composeMailWithParameters


on getDefaultMailAccount(senderAddress)
	
	set mailaddress to senderAddress
	if (mailaddress is "") then
		try
			set mailaddress to do shell script "defaults read com.apple.mail-shared NewMessageFromAddress"
		end try
	end if
	
	tell application "Mail"
		try
			set all_accounts to every account whose enabled is true
		on error
			set all_accounts to every account
		end try
		repeat with myaccount in all_accounts
			set myaddresses to email addresses of myaccount
			repeat with myaddress in myaddresses
				if (mailaddress contains myaddress) then
					return myaccount
				end if
			end repeat
		end repeat
		repeat with myaccount in all_accounts
			if name of myaccount contains "Default" then
				return myaccount
			end if
		end repeat
		return first item of all_accounts
	end tell
	
end getDefaultMailAccount


on splitString(theString, theDelimiter)
	-- save delimiters to restore old settings
	set oldDelimiters to AppleScript's text item delimiters
	-- set delimiters to delimiter to be used
	set AppleScript's text item delimiters to theDelimiter
	-- create the array
	set theArray to every text item of theString
	-- restore the old setting
	set AppleScript's text item delimiters to oldDelimiters
	-- return the result
	return theArray
end splitString