on composeMailWithParameters(params)
    
    set email_recipients to (recipients of params)
    set email_bccRecipients to (bccRecipients of params)
    set email_ccRecipients to (ccRecipients of params)
    
    set email_subject to (subject of params)
    set email_content to (body of params)
    set email_attachments to (attachments of params)
    set email_sender to (sender of params)
    
    set attachments to ""
    
    repeat with a_file in email_attachments
        if (attachments = "") then
            set aItem to "file://" & a_file
        else
            set aItem to "," & "file://" & a_file
        end if
        set attachments to attachments & aItem
    end repeat
    
    set recipients to ""
    
    repeat with a_recipient in email_recipients
        if (recipients = "") then
            set aItem to (emailaddress of a_recipient)
        else
            set aItem to "," & (emailaddress of a_recipient)
        end if
        set recipients to recipients & aItem
    end repeat
    
    
    set bcc to ""
    
    repeat with a_recipient in email_bccRecipients
        if (bcc = "") then
            set aItem to "" & (emailaddress of a_recipient)
        else
            set aItem to "," & (emailaddress of a_recipient)
        end if
        
        set bcc to bcc & aItem
    end repeat
    
    set cc to ""
    
    repeat with a_recipient in email_ccRecipients
        if (cc = "") then
            set aItem to "" & (emailaddress of a_recipient)
        else
            set aItem to "," & (emailaddress of a_recipient)
        end if
        
        set cc to cc & aItem
    end repeat
    
    
    set appPaths to (do shell script "mdfind -onlyin / kMDItemCFBundleIdentifier = \"org.mozilla.thunderbird\"") as text
    set appPath to paragraph 1 of appPaths
    
    
    try
        set thunderbird_bin to appPath & "/Contents/MacOS/thunderbird -compose "
        set email_content to my findAndReplace(return, "<br>", email_content)
        
        
        set tovar to "to=" & "\\'" & recipients & "\\'"
        set bccvar to "bcc=" & "\\'" & bcc & "\\'"
        set ccvar to "cc=" & "\\'" & cc & "\\'"
        
        set subjectvar to "subject=" & my urlencode(email_subject)
        set bodyvar to "body=" & my urlencode(email_content)
        set attachmentsvar to "attachment=" & "\\'" & attachments & "\\'"
        tell application id "org.mozilla.thunderbird" to activate
        
        delay 1

        do shell script thunderbird_bin & tovar & "," & bccvar & "," & ccvar & "," & subjectvar & "," & bodyvar & "," & attachmentsvar & " > /dev/null 2>&1 & "
        
    on error error_message number error_number
        log error_message & " " & error_number
    end try
    
end composeMailWithParameters

on escape(theString)
    return my findAndReplace("

", "%0d%0a", theString)
end escape



on findAndReplace(tofind, toreplace, theString)
    set ditd to text item delimiters
    set text item delimiters to tofind
    set textItems to text items of theString
    set text item delimiters to toreplace
    if (class of theString is string) then
        set res to textItems as string
    else -- if (class of TheString is Unicode text) then
        set res to textItems as Unicode text
    end if
    set text item delimiters to ditd
    return res
end findAndReplace


on urlencode(str)
    local str
    try
        return (do shell script "/bin/echo " & quoted form of str & ¬
            " | perl -MURI::Escape -lne 'print uri_escape($_)'")
    on error eMsg number eNum
        error "Can't urlEncode: " & eMsg number eNum
    end try
end urlencode

