//
//  SentryContext.h
//  Sentry
//
//  Created by Daniel Griesser on 18/05/2017.
//  Copyright © 2017 Sentry. All rights reserved.
//

#import <Foundation/Foundation.h>

#if __has_include(<Sentry/Sentry.h>)

#import <Sentry/SentrySerializable.h>

#else
#import "SentrySerializable.h"
#endif




@interface SentryContext : NSObject <SentrySerializable>

/**
 * Operating System information in contexts
 */
@property(nonatomic, strong) NSDictionary * osContext;

/**
 * Device information in contexts
 */
@property(nonatomic, strong) NSDictionary * deviceContext;

/**
 * App information in contexts
 */
@property(nonatomic, strong) NSDictionary * appContext;

- (instancetype)init;
+ (instancetype)new NS_UNAVAILABLE;

@end


