//
//  SentryDebugMeta.h
//  Sentry
//
//  Created by Daniel Griesser on 10/05/2017.
//  Copyright © 2017 Sentry. All rights reserved.
//

#import <Foundation/Foundation.h>

#if __has_include(<Sentry/Sentry.h>)
#import <Sentry/SentrySerializable.h>
#else
#import "SentrySerializable.h"
#endif




@interface SentryDebugMeta : NSObject <SentrySerializable>

/**
 * UUID of image
 */
@property(nonatomic, copy) NSString * uuid;

/**
 * Type of debug meta, mostly just apple
 */
@property(nonatomic, copy) NSString * type;

/**
 * CPU type of image
 */
@property(nonatomic, copy) NSNumber * cpuType;

/**
 * CPU Sub type of image
 */
@property(nonatomic, copy) NSNumber * cpuSubType;

/**
 * Name of the image
 */
@property(nonatomic, copy) NSString * name;

/**
 * Image size
 */
@property(nonatomic, copy) NSNumber * imageSize;

/**
 * Image VM address
 */
@property(nonatomic, copy) NSString * imageVmAddress;

/**
 * Image address
 */
@property(nonatomic, copy) NSString * imageAddress;

/**
 * Major version of the image
 */
@property(nonatomic, copy) NSNumber * majorVersion;

/**
 * Minor version of the image
 */
@property(nonatomic, copy) NSNumber * minorVersion;

/**
 * Revision version of the image
 */
@property(nonatomic, copy) NSNumber * revisionVersion;

- (instancetype)init;
+ (instancetype)new NS_UNAVAILABLE;

@end


