on composeMailWithParameters(params)
	
	set email_recipients to (recipients of params)
	set email_bccRecipients to (bccRecipients of params)
	set email_ccRecipients to (ccRecipients of params)
	
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)

    set appPath to (do shell script "mdfind kMDItemCFBundleIdentifier = \"com.freron.MailMate\"") as text
    set buildNumber to (do shell script "defaults read '" & appPath & "/Contents/Info' CFBundleVersion") as number

    if (buildNumber >= 5712) then
        set email_content to my findAndReplace((ASCII character 13), (ASCII character 10) & (ASCII character 13) , email_content)
    end

    tell application id "com.freron.MailMate"
		activate
		set attachments to ""
		
		repeat with a_file in email_attachments
			set aURL to "&attachment-url=file:///" & my urlencode(a_file)
			set attachments to attachments & aURL
		end repeat
		
		set recipients to ""
		
		repeat with a_recipient in email_recipients
			if (recipients = "") then
				set aItem to (name of a_recipient) & "<" &(emailaddress of a_recipient) & ">"
			else
				set aItem to "," & (name of a_recipient) & "<" &(emailaddress of a_recipient) & ">"
			end if
			set recipients to recipients & aItem
		end repeat
				
		
		set bcc to ""
		
		repeat with a_recipient in email_bccRecipients
			if (bcc = "") then
                set aItem to "&bcc=" & (name of a_recipient) & "<" &(emailaddress of a_recipient) & ">"
            else
                set aItem to "," & (name of a_recipient) & "<" &(emailaddress of a_recipient) & ">"
            end if
			
			set bcc to bcc & aItem
		end repeat
		
		set cc to ""
		
		repeat with a_recipient in email_ccRecipients
			if (cc = "") then
				set aItem to "&cc=" & (name of a_recipient) & "<" &(emailaddress of a_recipient) & ">"
			else
				set aItem to "," & (name of a_recipient) & "<" &(emailaddress of a_recipient) & ">"
			end if
			
			set cc to cc & aItem
		end repeat

		set sendstring to recipients & "?subject=" & email_subject & cc & bcc & "&body=" & email_content & attachments
  
  
        open mailto sendstring with trust
		
	end tell
	
end composeMailWithParameters

on urlencode(str)
	local str
	try
		return (do shell script "/bin/echo " & quoted form of str & ¬
			" | perl -MURI::Escape -lne 'print uri_escape($_)'")
	on error eMsg number eNum
		error "Can't urlEncode: " & eMsg number eNum
	end try
end urlencode


on findAndReplace(tofind, toreplace, theString)
    set ditd to text item delimiters
    set text item delimiters to tofind
    set textItems to text items of theString
    set text item delimiters to toreplace
    if (class of theString is string) then
        set res to textItems as string
    else -- if (class of theString is Unicode text) then
        set res to textItems as Unicode text
    end if
    set text item delimiters to ditd
    return res
end findAndReplace
