on composeMailWithParameters(params)
	
	set email_recipient to (recipient of params)
    set email_recipients to (recipients of params)
    set email_bccRecipients to (bccRecipients of params)
    set email_ccRecipients to (ccRecipients of params)

	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
    set email_sender to (sender of params)

	try
		tell application "Microsoft Outlook"
			activate
			set email_content to my findAndReplace(return, "<br>", email_content)
			set tmp to make new outgoing message with properties {subject:email_subject, content:email_content}
            try
            set account of tmp to my getDefaultMailAccount(email_sender)
            end try
			if (email_recipient is not "") then
                repeat with a_recipient in email_recipients
                    make new to recipient at tmp with properties {email address:{address:(emailaddress of a_recipient), name:(name of a_recipient)}}
                end repeat
                
                repeat with a_recipient in email_ccRecipients
                    make new cc recipient at tmp with properties {email address:{address:(emailaddress of a_recipient), name:(name of a_recipient)}}
                end repeat
                
                 repeat with a_recipient in email_bccRecipients
                    make new bcc recipient at tmp with properties {email address:{address:(emailaddress of a_recipient), name:(name of a_recipient)}}
                end repeat
			end if
            repeat with a_file in email_attachments
                try
                    make new attachment at tmp with properties {file:a_file}
                on error errMsg
                    make new attachment at tmp with properties {file:a_file as POSIX file}
                end try
            end repeat
			open tmp
		end tell
	end try
	
end composeMailWithParameters


on getDefaultMailAccount(senderAddress)
	
	tell application "Microsoft Outlook"
		
		repeat with myaccount in exchange accounts
			if email address of myaccount is senderAddress then
				return myaccount
			end if
		end repeat
		repeat with myaccount in imap accounts
			if email address of myaccount is senderAddress then
				return myaccount
			end if
		end repeat
		return default account
	end tell
	
	
end getDefaultMailAccount



on findAndReplace(tofind, toreplace, theString)
	set ditd to text item delimiters
	set text item delimiters to tofind
	set textItems to text items of theString
	set text item delimiters to toreplace
	if (class of theString is string) then
		set res to textItems as string
	else -- if (class of theString is Unicode text) then
		set res to textItems as Unicode text
	end if
	set text item delimiters to ditd
	return res
end findAndReplace