on composeMailWithParameters(params)
	
	set email_recipients to (recipients of params)
	set email_bccRecipients to (bccRecipients of params)
	set email_ccRecipients to (ccRecipients of params)
	
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
	
	tell application "Spark"
        activate
		set attachments to ""
		
		repeat with a_file in email_attachments
			set aURL to "&attachment-url=file:///" & my urlencode(a_file)
			set attachments to attachments & aURL
		end repeat
		
		set recipients to ""
		
		repeat with a_recipient in email_recipients
			if (recipients = "") then
				set aItem to (emailaddress of a_recipient)
			else
				set aItem to "," & (emailaddress of a_recipient)
			end if
			set recipients to recipients & aItem
		end repeat
				
		
		set bcc to ""
		
		repeat with a_recipient in email_bccRecipients
			if (bcc = "") then
				set aItem to "&bcc=" & (emailaddress of a_recipient)
			else
				set aItem to "," & (emailaddress of a_recipient)
			end if
			
			set bcc to bcc & aItem
		end repeat
		
		set cc to ""
		
		repeat with a_recipient in email_ccRecipients
			if (cc = "") then
				set aItem to "&cc=" & (emailaddress of a_recipient)
			else
				set aItem to "," & (emailaddress of a_recipient)
			end if
			
			set cc to cc & aItem
		end repeat

		set sendstring to "mailto:" & recipients & "?subject=" & my urlencode(email_subject) & cc & bcc & "&body=" & my urlencode(email_content) & attachments

		open location sendstring

        repeat with a_file in email_attachments
            open a_file
        end repeat


	end tell
	
end composeMailWithParameters

on urlencode(str)
	local str
	try
		return (do shell script "/bin/echo " & quoted form of str & ¬
			" | perl -MURI::Escape -lne 'print uri_escape($_)'")
	on error eMsg number eNum
		error "Can't urlEncode: " & eMsg number eNum
	end try
end urlencode
