//
//  MAStoreCache.h
//  MAStore
//
//  Created by Stefan Fuerst on 23.04.18.
//  Copyright (c) 2018 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Cocoa/Cocoa.h>

@class StorageKitStore;
@class StorageKitCacheItem;
@class StorageKitCacheArray;


@interface StorageKitCache : NSObject

@property (nonatomic,strong) NSMutableDictionary * entities;
@property (nonatomic,strong) StorageKitCacheArray * changeLog;
@property (nonatomic,strong) NSMutableDictionary * uids;
@property (nonatomic,strong) NSMutableSet * objectIDsToRefresh;

@property (nonatomic,strong) NSURL * storeURL;
@property (nonatomic,strong) NSURL * URL;
@property (nonatomic,assign) StorageKitStore * store;
@property (nonatomic,strong) dispatch_queue_t queue;
@property (nonatomic) BOOL terminated;
@property (nonatomic) NSInteger itemsToLoad;
@property (nonatomic) NSInteger itemsToIndex;
@property (nonatomic) NSInteger maxItemsToIndex;
@property (nonatomic) BOOL cachedMissingItems;

@property (nonatomic,strong) NSMutableSet * itemsLoading;
@property (nonatomic,strong) NSOperationQueue * saveQueue;
@property (nonatomic,strong) NSOperationQueue * indexQueue;

+(instancetype)cacheForStore:(StorageKitStore *)store;
+(NSURL *)cacheURLForStoreURL:(NSURL *)storeURL;
-(void)cacheMissingItems;
+(void)resetCacheForURL:(NSURL *)storeURL;
+(void)resetAllCaches;
-(void)checkAllFiles;
-(void)reset;
-(BOOL)removeObjectID:(NSManagedObjectID *)theID;
-(NSArray *)changesHistoryForObjectID:(NSManagedObjectID *)theID;
//-(NSArray *)changesHistoryForObjectID:(NSManagedObjectID *)theID delegate:(id)delegate;
-(void)compactObjectIDs:(NSArray *)theIDs;
-(NSMutableSet *)objectUIDsForEntity:(NSEntityDescription *)entity;
-(NSDictionary *)valuesForObjectID:(NSManagedObjectID *)theID forContext:(NSManagedObjectContext *)context;
-(NSDictionary *)allValuesForObjectID:(NSManagedObjectID *)theID forContext:(NSManagedObjectContext *)context;
-(NSDictionary *)attributesForObjectID:(NSManagedObjectID *)theID forContext:(NSManagedObjectContext *)context;
-(StorageKitCacheItem *)cacheItemForObjectID:(NSManagedObjectID *)theID;
-(StorageKitCacheItem *)cacheItemForObjectID:(NSManagedObjectID *)theID forContext:(NSManagedObjectContext *)context;
-(void)updateCacheForObjectID:(NSManagedObjectID *)theID withValues:(NSDictionary *)values andURL:(NSURL *)url;

//-(NSMutableDictionary *)cacheForEntity:(NSEntityDescription *)theEntity;
-(void)save:(id)sender;
-(void)saveInBundle:(id)sender;
-(void)addChange:(NSDictionary *)change isExternal:(BOOL)isExternal;
-(void)removeChange:(NSDictionary *)change isExternal:(BOOL)isExternal;

-(void)resetExtraDataForObjectID:(NSManagedObjectID *)theID;
-(void)setExtraData:(id)data forKey:(NSString *)key forObjectID:(NSManagedObjectID *)theID;
-(id)extraDataForKey:(NSString *)key forObjectID:(NSManagedObjectID *)theID;

-(void)addObjectUIDs:(NSDictionary *)dictionary isExternal:(BOOL)isExternal;
-(void)removeObjectUIDs:(NSDictionary *)dictionary isExternal:(BOOL)isExternal;
-(NSArray *)changes;
-(void)loadCachesForEntity:(NSEntityDescription *)entity;

@end
