//
//  SFCSVImporterViewController.h
//  XLBridge
//
//  Created by Stefan Fuerst on 20.05.16.
//  Copyright (c) 2016 Media Atelier. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "SFCSVImporterMapper.h"





@class SFCSVImporter;
@class SFCSVImporterDataArrayController;
@protocol SFCSVImporterDelegate;

@interface SFCSVImporterViewController : NSViewController

+(SFCSVImporterViewController*)importerViewControllerWithContentsOfFile:(NSString *)path delegate:(id <SFCSVImporterDelegate>) delegate;
+(SFCSVImporterViewController*)importerViewControllerWithString:(NSString *)string delegate:(id <SFCSVImporterDelegate>) delegate;
+(SFCSVImporterViewController*)importerViewControllerWithPasteboard:(NSPasteboard *)pasteboard delegate:(id <SFCSVImporterDelegate>) delegate;


@property (nonatomic,strong) SFCSVImporter * importer;
@property (nonatomic) IBOutlet NSButton * importButton;
@property (nonatomic) IBOutlet NSButton * alternateButton;
@property (nonatomic) IBOutlet NSButton * skipHeadersButton;
@property (nonatomic,strong) NSViewController * accessoryViewController;

@property (nonatomic) IBOutlet NSView * accessoryView;

@property (nonatomic) IBOutlet NSTableView * tableView;
@property (nonatomic) IBOutlet NSSegmentedControl * rowStepperControl;
@property (nonatomic) IBOutlet SFCSVImporterDataArrayController * importerDataArrayController;
@property (nonatomic) IBOutlet NSArrayController * mappingArrayController;
@property (nonatomic) IBOutlet NSArrayController * fieldsArrayController;
@property (nonatomic,strong) NSArray * mappings;

@property (nonatomic) NSInteger lineCount;
@property (nonatomic,weak) id <SFCSVImporterDelegate> delegate;

-(IBAction)import:(id)sender;
-(IBAction)alternateButtonAction:(id)sender;
-(IBAction)rowStepperControlAction:(id)sender;
-(SFCSVImporterMapper *)mapperForKey:(NSString *)key;
-(BOOL)hasLinesToImport;
@end


@protocol SFCSVImporterDelegate <NSObject>

@required
-(void)importerViewController:(SFCSVImporterViewController *)controller import:(NSDictionary *)values;
-(NSArray *)mappersForImporterViewController:(SFCSVImporterViewController *)controller;

@optional
-(void)importerViewController:(SFCSVImporterViewController *)controller willImport:(NSArray *)keys;
-(void)importerViewController:(SFCSVImporterViewController *)controller didImport:(NSArray *)keys;
-(void)importerViewController:(SFCSVImporterViewController *)controller alternateButtonAction:(id)sender;
-(NSArray *)fieldOrderForImporterViewController:(SFCSVImporterViewController *)controller;
-(void)importerViewController:(SFCSVImporterViewController *)controller updateFieldOrder:(NSArray *)array;
-(void)importerViewController:(SFCSVImporterViewController *)controller didReceiveError:(NSError*)error;


@end
