//
//  SentryException.h
//  Sentry
//
//  Created by Daniel Griesser on 05/05/2017.
//  Copyright © 2017 Sentry. All rights reserved.
//

#import <Foundation/Foundation.h>

#if __has_include(<Sentry/Sentry.h>)
#import <Sentry/SentryDefines.h>
#import <Sentry/SentrySerializable.h>
#else
#import "SentryDefines.h"
#import "SentrySerializable.h"
#endif



@class SentryThread, SentryMechanism;


@interface SentryException : NSObject <SentrySerializable>
SENTRY_NO_INIT

/**
 * The name of the exception
 */
@property(nonatomic, copy) NSString *value;

/**
 * Type of the exception
 */
@property(nonatomic, copy) NSString *type;

/**
 * Additional information about the exception
 */
@property(nonatomic, strong) SentryMechanism * mechanism;

/**
 * Can be set to define the module
 */
@property(nonatomic, copy) NSString * module;

/**
 * Determines if the exception was reported by a user BOOL
 */
@property(nonatomic, copy) NSNumber * userReported;

/**
 * SentryThread of the SentryException
 */
@property(nonatomic, strong) SentryThread * thread;

/**
 * Initialize an SentryException with value and type
 * @param value String
 * @param type String
 * @return SentryException
 */
- (instancetype)initWithValue:(NSString *)value type:(NSString *)type;

@end


