//
//  SentryOptions.h
//  Sentry
//
//  Created by Daniel Griesser on 12.03.19.
//  Copyright © 2019 Sentry. All rights reserved.
//

#import <Foundation/Foundation.h>

#if __has_include(<Sentry/Sentry.h>)
#import <Sentry/SentryDefines.h>
#else
#import "SentryDefines.h"
#endif



@class SentryDsn;


@interface SentryOptions : NSObject
SENTRY_NO_INIT

    
/**
 * Init SentryOptions.
 * @param options Options dictionary
 * @return SentryOptions
 */
- ( instancetype)initWithOptions:(NSDictionary *)options
                         didFailWithError:(NSError * *)error;
    
/**
 * The Dsn passed in the options.
 */
@property(nonatomic, strong) SentryDsn *dsn;

/**
 * This property will be filled before the event is sent.
 */
@property(nonatomic, copy) NSString * releaseName;

/**
 * This property will be filled before the event is sent.
 */
@property(nonatomic, copy) NSString * dist;

/**
 * The environment used for this event
 */
@property(nonatomic, copy) NSString * environment;
    
/**
 * Is the client enabled?. Default is @YES, if set @NO sending of events will be prevented.
 */
@property(nonatomic, copy) NSNumber *enabled;

@end


