//
//  SentryQueueableRequestManager.h
//  Sentry
//
//  Created by Daniel Griesser on 05/05/2017.
//  Copyright © 2017 Sentry. All rights reserved.
//

#import <Foundation/Foundation.h>

#if __has_include(<Sentry/Sentry.h>)

#import <Sentry/SentryDefines.h>

#else
#import "SentryDefines.h"
#endif



@protocol SentryRequestManager

@property(nonatomic, readonly, getter = isReady) BOOL ready;

- (instancetype)initWithSession:(NSURLSession *)session;

- (void)addRequest:(NSURLRequest *)request completionHandler:( SentryRequestOperationFinished)completionHandler;

- (void)cancelAllOperations;

@end

@interface SentryQueueableRequestManager : NSObject <SentryRequestManager>

@end


