//
//  MAPersistentDocument.h
//  MAStore
//
//  Created by Stefan Fuerst on 22.04.18.
//  Copyright (c) 2018 Media Atelier. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "StorageKitSavePanel.h"


@class StorageKitBusyWindowController;
@class StorageKitInfoWindowController;
@class StorageKitHistoryWindowController;

@class StorageKitStore;
@class StorageKitSavePanel;

@interface StorageKitDocument : NSPersistentDocument <NSWindowDelegate>

@property (nonatomic,strong) NSString * password;
@property (nonatomic,strong) StorageKitInfoWindowController * infoWindowController;
@property (nonatomic,strong) StorageKitHistoryWindowController * historyWindowController;

@property (nonatomic) NSInteger itemsToLoad;
@property (nonatomic) NSInteger maxItemsToLoad;
@property (nonatomic,strong) NSString * documentIdentifier;
@property (nonatomic,strong) NSString * deviceIdentifier;

@property (nonatomic) BOOL merging;
@property (nonatomic) BOOL busy;
@property (nonatomic) BOOL ready;
@property (nonatomic) BOOL checkReadyState;
@property (nonatomic) BOOL closed;
@property (nonatomic,strong) NSString * errorLevel;

@property (nonatomic,strong) StorageKitBusyWindowController * busyWindowController;

-(IBAction)showInfoSheet:(id)sender;
-(IBAction)rebuildCache:(id)sender;

-(void)showHistorySheetForManagedObjectID:(NSManagedObjectID *)managedObjectID;
-(void)showHistorySheetForManagedObjectID:(NSManagedObjectID *)managedObjectID delegate:(id)delegate;

-(IBAction)resetCache;
-(IBAction)checkAllFiles;
-(StorageKitStore *)store;
+(StorageKitSavePanel *)savePanel;
+(BOOL)isCorrectFormat:(NSString *)path;
-(NSArray *)infoArray;
-(BOOL)preflightData:(NSManagedObjectContext *)context;
-(BOOL)validateURL:(NSURL *)URL withAlert:(BOOL)withAlert;
-(void)saveAll;
-(void)saveDocumentUpToChange:(id)sender;
-(void)documentDidBecomeReady;
-(void)documentDidResignReady;

-(BOOL)hasError;

@end



@interface StorageKitUndoManager : NSUndoManager

@property (nonatomic,strong) NSMutableArray * myUndoStack;
@property (nonatomic,strong) NSMutableArray * myRedoStack;
@property (nonatomic,strong) NSMutableArray * targets;


@end


@interface StorageKitStatusToolBarItem : NSToolbarItem

@property (nonatomic,strong) StorageKitDocument * document;
@property (nonatomic,strong) NSButton * button;
@property (nonatomic,strong) NSString * errorLevel;

-(id)initWithItemIdentifier:(NSString *)itemIdentifier andDocument:(StorageKitDocument *)document;

@end


@interface StorageKitStatusButton : NSButton

@property (nonatomic,assign) IBOutlet StorageKitDocument * document;
@property (nonatomic,strong) NSString * errorLevel;

@end
