//
//  StorageKitSetPasswordViewController.h
//  StorageKit
//
//  Created by Stefan Fuerst on 28.05.18.
//  Copyright (c) 2018 Media Atelier. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "StorageKitStore.h"

@interface StorageKitSetPasswordViewController : NSViewController <NSOpenSavePanelDelegate>

@property (nonatomic, assign) BOOL usePassword;
@property (nonatomic, strong) NSString * password;
@property (nonatomic, strong) NSString * passwordRepeat;
@property (nonatomic, strong) NSSavePanel * panel;

@property (nonatomic, assign) BOOL passwordMatching;
@property (nonatomic, assign) NSButton * panelButton;
@property (nonatomic, assign) BOOL saveToKeychain;
@property (nonatomic, assign) IBOutlet NSWindow * busyWindow;
@property (nonatomic, assign) IBOutlet NSImageView * warningImageView;
@property (nonatomic, assign) IBOutlet NSImageView * matchingWarningImageView;
@property (nonatomic, assign) IBOutlet NSButton * helpButton;

-(void)savePasswordForStore:(StorageKitStore *)store;
@end


@interface StorageKitSetPasswordViewController (Dummy)
-(IBAction)storageKitPasswordHelpButtonAction:(id)sender;
@end

@interface NSView (find)

-(void)findButtonWithAction:(SEL)action button:(NSButton **)button;

@end


@interface StorageKitPasswordAccessoryView : NSView
@end


@interface StorageKitLevelIndicator : NSLevelIndicator
@end
