//
//  SKRepository.h
//  SyncKit3
//
//  Created by Stefan on 31.03.15.
//  Copyright (c) 2015 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SKDevice;
@class SKManagedObjectContext;
@class SKLogger;

@interface SKRepository : NSObject

@property (nonatomic,weak) SKManagedObjectContext * managedObjectContext;
@property (nonatomic,strong) NSString * basePath;
@property (nonatomic) NSInteger number;
@property (nonatomic,strong) NSMutableSet * devices;
@property (nonatomic,strong) NSDictionary * localDictionary;
@property (nonatomic,strong) NSMutableDictionary * uidCache;
@property (nonatomic,strong) NSMutableDictionary * sortOrders;
@property (nonatomic,strong) NSMutableArray * errors;
@property (nonatomic,strong) NSArray * validEntityNames;
@property (nonatomic,strong) NSDate * maxDate;


@property (nonatomic,strong) NSURL * remoteURL;

+(SKRepository *)repositoryWithPath:(NSString *)basePath managedObjectContext:(SKManagedObjectContext *)context;
-(void)loadLocalDevices;
-(void)loadRemoteDevices;
-(NSMutableSet *)remoteDevices;
-(NSMutableArray *)remoteChanges;
-(SKDevice *)addDevice:(SKDevice *)device;
-(NSString *)path;
-(NSURL *)remoteURL;
-(NSString *)dataPath;
-(BOOL)uploadChanges;
-(BOOL)downloadChanges;
-(void)loadChanges:(NSManagedObjectContext *)context;
-(NSMutableArray *)loadChangesFromDate:(NSDate *)date;
-(NSArray *)possibleDownloads;
-(void)loadLocalDictionary;
-(void)cleanUpSync;
-(NSString *)syncDateKey;
-(void)loadAll;
-(NSArray *)allErrors;
-(NSInteger)remoteVersion;
-(void)notifyChanges;
-(void)copyBackupDeviceFromRepository:(SKRepository *)repository;
-(NSMutableDictionary *)infoDictionary;
-(SKLogger *)logger;
-(void)rewindBy24hours;
-(NSArray *)changeLogForUID:(NSString *)theUID;
-(void)notifyContext:(NSManagedObjectContext *)context type:(NSString *)type progressValue:(NSInteger)progressValue progressMax:(NSInteger)progressMax;


@end
