//
//  SendMailKit.h
//  SendMailKit
//
//  Created by Stefan on 20.02.13.
//  Copyright (c) 2013 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SendMailKitMessage.h"
#import "NSString+Email.h"


@interface SendMailKit : NSObject
{
}

@property (strong,nonatomic) NSMutableSet * userScriptsPaths;
@property (strong,nonatomic) NSArray * sharingServices;
@property (assign) BOOL includeSharingServices;


+(SendMailKit *)sharedKit;
+(void)editScript;
+(NSString *)defaultScriptPath;
+(NSString *)defaultMailClient;
+(NSString *)defaultMailClientName;
+(NSSharingService *)defaultSharingService;
+(NSArray *)userScripts;


+(BOOL)installScript:(NSString *)path;
+(void)removeUserScripts;

+(void)addUserScriptsPath:(NSString *)path;
+ (SendMailKitMessage *)messageWithSubject:(NSString *)subject body:(NSString *)body recipients:(NSArray *)recipients attachments:(NSArray *)attachments;
+(SendMailKitMessage *)messageWithSubject:(NSString *)subject body:(NSString *)body recipient:(NSString *)recipient attachment:(NSString *)attachment;
+ (SendMailKitMessage *)messageWithSubject:(NSString *)subject body:(NSString *)body recipient:(NSString *)recipient attachments:(NSArray *)attachments;
+(NSString *)temporaryDirectory;
+(NSMenu *)supportedMailClientsMenu;
-(NSString *)pluginsList;

@end
