on composeMailWithParameters(params)
	
	set email_recipients to (recipients of params)
    set email_bccRecipients to (bccRecipients of params)
    set email_ccRecipients to (ccRecipients of params)

	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
    set email_sender to (sender of params)

	tell application "Mailplane"
		set m to make new outgoing message
		tell m
            repeat with a_recipient in email_recipients
				set r to make new to recipient at end
				tell r
					set address to (emailaddress of a_recipient)
                    set name to (name of a_recipient)
				end tell
			end repeat
            
            repeat with a_recipient in email_ccRecipients
				set r to make new cc recipient at end
				tell r
					set address to (emailaddress of a_recipient)
                    set name to (name of a_recipient)
				end tell
			end repeat

            repeat with a_recipient in email_bccRecipients
				set r to make new bcc recipient at end
				tell r
					set address to (emailaddress of a_recipient)
                    set name to (name of a_recipient)
				end tell
			end repeat
            
            
            if (email_sender is not "") then
                set sender to email_sender
            end if
			set subject to email_subject
			set content to email_content
			repeat with a_file in email_attachments
				if a_file is not "" then
					make new mail attachment with properties {path:a_file}
				end if
			end repeat
		end tell
		compose m
		activate
	end tell
	
end composeMailWithParameters


on splitString(theString, theDelimiter)
	-- save delimiters to restore old settings
	set oldDelimiters to AppleScript's text item delimiters
	-- set delimiters to delimiter to be used
	set AppleScript's text item delimiters to theDelimiter
	-- create the array
	set theArray to every text item of theString
	-- restore the old setting
	set AppleScript's text item delimiters to oldDelimiters
	-- return the result
	return theArray
end splitString